<?php
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Albert+Sans:ital,wght@0,100..900;1,100..900&family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
    <title>Starship Showdown</title>
</head>
<body>
    <div class="bar"></div>
    <div class="wrapper">
        <div class="combat1">
            <div class="combat11">
                <div class="title">
                    <p class="tour section-title albert-sans left">TOUR 1</p>
                    <p class="section-title albert-sans right red">FLOTTE ENNEMIE</p>
                </div>
                
                <div class="combat">
                    <?php include_once "combat.php"; ?>
                </div>
                <p class="section-title albert-sans left fl-joueur">FLOTTE JOUEUR</p>
            </div>
            <div class="bar3"></div>
            <div class="attaquant-actuel albert-sans section-title left"></div>
            <div class="attack">
                <div class="moves">
                    <div class="moves-list"></div>
                </div>
                <div class="choices"></div>
            </div>
        </div>
        <div class="bar2"></div>
        <div class="menu">
            <div class="menu-buttons">
                <button id="reset-btn" class="btn-normal albert-sans">recommencer</button>
                <button id="back-btn" class="btn-rouge albert-sans">abandonner</button>
            </div>
            <p class="section-title right albert-sans deroule">DÉROULÉ</p>
            <div class="dashboard">
                <p class="text-start"><strong>Le combat commence !</strong></p>
                <div class="text-container"></div>
            </div>
        </div>



        <div id="overlay" class="overlay">
            <div class="overlay-content">
                <p>Êtes-vous sûr de vouloir abandonner le combat ?</p>
                <button id="confirm-abandon" class="btn-rouge">OK</button>
                <button id="cancel-abandon" class="btn-normal">Annuler</button>
            </div>
        </div>  
    </div>

    <script>



        function chargerMovesList(id_vaisseau) {
            $.ajax({
                type: "POST",
                url: "combat.php",
                data: { action: 'afficherMovesList'},
                success: function(response) {
                    $('.moves-list').html(response);
                },
                error: function() {
                    alert('Erreur lors du chargement des mouvements.');
                }
            });
        }

        function chargerAttaquantActuel() {
            $.ajax({
                type: "POST",
                url: "combat.php",
                data: { action: 'afficherAttaquantActuel' },
                success: function(response) {
                    $('.attaquant-actuel').html(response);
                }
            });
        }

        function chargerEnnemiActuel() {
            $.ajax({
                type: "POST",
                url: "combat.php",
                data: { action: 'afficherEnnemiActuel' },
                success: function(response) {
                    $('.flotte:last-child .nom-flotte').append(response);
                }
            });
        }

        $(document).ready(function() {
            chargerEnnemiActuel();
            chargerAttaquantActuel();
            chargerMovesList();
            
            // Actions sur le bouton "Retour"
            $('#back-btn').click(function() {
                $('#overlay').css('display', 'flex');
                $('#overlay').show(); 
            });

            $('#cancel-abandon').click(function() {
                $('#overlay').hide(); // Cache l'overlay si l'utilisateur annule
            });

            $('#confirm-abandon').click(function() {
                // Envoi d'une requête AJAX pour réinitialiser et rediriger vers accueil.php
                $.ajax({
                    url: 'combat.php',
                    type: 'POST',
                    data: { abandon: 'true' }, // Vous envoyez une indication de réinitialisation
                    success: function() {
                        window.location.href = 'accueil.php'; // Redirection après confirmation
                    },
                    error: function() {
                        alert('Erreur lors de la réinitialisation');
                    }
                });
            });

            $('#reset-btn').click(function() {
                $.ajax({
                    url: 'combat.php',
                    type: 'POST',
                    data: { reset: 'true' },
                    success: function() {
                        location.reload();
                    },
                    error: function() {
                        alert('Erreur de réinitialisation');
                    }
                });
            });

            $('.moves').on('click', '.move', function() {
                var moveId = $(this).data("id");  // Récupère l'ID du mouvement à partir de l'attribut data-id
                // Stocke le moveId dans l'élément .choices
                $('.choices').data('move-id', moveId);

                $.ajax({
                    url: 'combat.php',
                    type: 'POST',
                    data: { moveChoice: true },  // Envoie l'ID du mouvement dans la requête
                    success: function(response) {
                        $('.choices').empty().html(response).show();
                    },
                    error: function() {
                        alert('Erreur de requête');
                    }
                });
            });

            $('.choices').on('click', '#vaisseau-choice', function() {
                var choixVaisseauEnnemi = $(this).data("vaisseau-id");
                var moveId = $('.choices').data('move-id');
                console.log(moveId);
                
                $.ajax({
                    url: 'combat.php',
                    type: 'POST',
                    data: { 
                        attack1: 'true', 
                        vaisseau_id: choixVaisseauEnnemi, 
                        move_id: moveId // Ajoute le moveId dans la requête
                    },
                    success: function(response) {
                        $('.text-container').append($('<div class="text"></div>').html($(response).filter('.text').html()));
                        $('.combat').html($(response).filter('.combat-info').html());
                        $('.tour').html("TOUR "+$(response).filter('.tour').html());
                        if (response.includes('Victoire du joueur')) {
                            $('.moves, .flotte').hide();
                        } else if (response.includes("Victoire de l'ennemi")) {
                            $('.moves, .flotte').hide();
                        }
                        $('.choices').hide();
                        $('.dashboard').scrollTop($('.dashboard')[0].scrollHeight);

                        chargerEnnemiActuel();
                        chargerAttaquantActuel();
                        chargerMovesList();
                    },
                    error: function() {
                        alert('Erreur de requête');
                    }
                });
            });

        });
    </script>
</body>
</html>
