<?php
  session_start();

  //Redirection si pas connecté
  if (!isset($_SESSION['pseudo'])) {
    header("Location: connexion.php"); 
    exit();
}

  //Connexion à la base de données
  $conn = new mysqli("localhost", "marwan_trc", "pokemonepee1511", "marwan_resa_manga");

  $select_resa = $conn->prepare("SELECT c.id_client, c.pseudo,
  r.id_reservation, r.date_reservation, r.date_debut, r.date_fin, 
  m.titre, m.auteur, m.cover, g.nom_genre 
  FROM client as c 
  LEFT JOIN reservation as r ON c.id_client = r.id_client 
  LEFT JOIN reservation_manga as rm ON r.id_reservation = rm.id_reservation 
  LEFT JOIN manga as m ON rm.id_manga = m.id_manga 
  LEFT JOIN genre as g ON m.id_genre = g.id_genre 
  WHERE c.pseudo = ?
  ORDER BY r.id_reservation DESC ; ");
  $select_resa-> bind_param('s', $_SESSION['pseudo']);
  $select_resa-> execute();
  $result = $select_resa->get_result();

?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="main.css">
  <title>Espace client - Plume</title>
</head>
<body>

  <header>
    <h1>Plume</h1>
    <nav>
      <a href="homepage_client.php">Réserver des mangas</a>
      <a href="reservations.php">Vos réservations</a>
      <a href="deconnexion.php" class="deco">Déconnexion</a>
      <p><?php echo $_SESSION['pseudo'];?> - Espace Client</p>
    </nav>
  </header>

  <main>
    <h2 class="page-title">Vos réservations</h2>
      <div class="resa-list">
        <?php //On affiche les réservations dans un format de tuiles

          //On crée une variable qui va indiquer à quel moment on passe à une nouvelle réservation
          $resa_act = null;

          if ($result->num_rows > 0) {
            while ($col = $result->fetch_assoc()) {
              if ($resa_act !== $col['id_reservation']) {

                //On vérifie que si il y'a une réservation avant, elle est bien cloturée
                if ($resa_act !== null) {
                    echo "</div>"; // Fin de la div manga-card-container
                    echo "</div>"; // Fin de la div resa-card
                }

                // On actualise la variable
                $resa_act = $col['id_reservation'];

                //On affiche les réservations
                echo "<div class='resa-card'>";
                echo "  <div class='resa-card-header'>";
                echo "      <p class='resa-card-titre'> Réservation n° ".$col['id_reservation']." </p>";
                echo "  </div>";
                echo "  <div class='resa-card-dates'>";
                echo "      <p class='resa-card-start'> Récupérez vos mangas à partir du <strong>".$col['date_debut']."</strong> </p>";
                echo "      <p class='resa-card-end'> À rendre le <strong>".$col['date_fin']."</strong> </p>";
                echo "  </div>";
                echo "<div class='manga-card-container'>";
              }

            // Informations des mangas associés à la réservation actuelle
            echo "<div class='manga-card' style='background-image: url(".$col['cover']."); background-size: cover; background-position: top; '>";

            echo "  <p class='manga-card-titre'> ".$col['titre']." </p>";
            echo "  <p class='manga-card-auteur'> ".$col['auteur']." </p>";
            echo "  <p class='manga-card-genre'> ".$col['nom_genre']." </p>";
            echo "</div>";
            }

            // Fin de la dernière réservation
            if ($resa_act !== null) {
              echo "</div>"; 
              echo "</div>"; 
            }
            } else {
                echo "<p> Aucune réservation trouvée. </p>";
            }
        ?>
      </div>

  </main>

  <div class="admin-link"><a href="admin.php">Espace<br>Administrateur</a></div>
  
</body>
</html>