<?php
session_start();

include_once "dex.php";  // Assure-toi que les vaisseaux sont définis ici

if (!isset($_SESSION['login'])) {
    // Si l'utilisateur n'est pas connecté, rediriger vers la page de connexion
    header("Location: authentification/connexion.php");
    exit();
}

try {
    $host = 'localhost'; 
    $db = 'starship_showdown';  
    $user = 'root';  
    $pass = ''; 
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8";

    // Créer une instance PDO
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Récupérer le login de l'utilisateur connecté
    $login = $_SESSION['login'];

    // Requête pour récupérer la flotte de l'utilisateur
    $stmt = $pdo->prepare("SELECT * FROM flotte WHERE login = :login");
    $stmt->execute(['login' => $login]);
    $flotte = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($flotte) {
        // Récupérer les IDs des vaisseaux
        $vaisseaux = [
            $flotte['vaisseau_1'],
            $flotte['vaisseau_2'],
            $flotte['vaisseau_3'],
            $flotte['vaisseau_4'],
            $flotte['vaisseau_5']
        ];
        
        // Récupérer les détails des vaisseaux à partir de leur ID
        $vaisseauxDetails = [];
        foreach ($vaisseaux as $vaisseauId) {
            if (isset($liste_vaisseaux[$vaisseauId])) {
                $vaisseauxDetails[] = $liste_vaisseaux[$vaisseauId]; 
            }
        }
    } else {
        $vaisseauxDetails = [];  // Aucun vaisseau trouvé
    }

} catch (PDOException $e) {
    echo 'Erreur : ' . $e->getMessage();
    $vaisseauxDetails = [];
}

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Albert+Sans:ital,wght@0,100..900;1,100..900&family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
    <title>Page d'Accueil</title>
</head>
<body>
    <div class="no-responsive"></div>
    <div class="bar"></div>
    <div class="blackline"></div>
    <div class="wrapper3">
        <div class="home-title">
            <div class="home-title1">
                <p class="section-title albert-sans left">FLOTTE</p>
                <div class="home-text">
                    <p>Votre flotte actuelle.</p>
                    <p>Bienvenue, <?php echo htmlspecialchars($_SESSION['login']); ?></p>
                </div>
            </div>
            <div class="home-flotte-list">
                <?php if (empty($vaisseauxDetails)): ?>
                    <p>Aucun vaisseau dans votre flotte.</p>
                <?php else: ?>
                    <?php foreach ($vaisseauxDetails as $vaisseau): ?>
                        <div class="home-flotte-vaisseau">
                        <?php echo $vaisseau->showVaisseauAccueil(); ?>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        <div class="bar3"></div>
        <div class="home-menu">
            <div class="menu-1">
                <p class="section-title albert-sans right sec-tit-menu">MENU</p>
                <div class="menu-list">
                    <div class="menu-element">
                        <p>Sélectionnez ici les vaisseaux de votre flotte.<br>Pas de doublons autorisés.<br>5 vaisseaux maximum.</p>
                        <div class="blackline-menu"></div>
                        <a href="choix.php" class="btn-normal albert-sans">utiliser le h:Angar</a>
                    </div>
                    <div class="menu-element">
                        <p>Combat de vaisseaux en cinq contre cinq.<br>Les ennemis sont toujours les mêmes.</p>
                        <div class="blackline-menu"></div>
                        <a href="index.php" class="btn-normal albert-sans">lancer un combat</a>
                    </div>
                    <div class="menu-element">
                        <p>Pour mieux comprendre le jeu.</p>
                        <div class="blackline-menu"></div>
                        <a href="#" class="btn-normal albert-sans">manuel de jeu</a>
                    </div>
                </div>
            </div>
            <form method="POST" action="authentification/deconnexion.php">
                <button type="submit" class="btn-normal albert-sans">déconnexion</button>
            </form>
        </div>
    </div>

    <div id="overlay" class="overlay-manual">
        <div class="overlay-content-manual">
            <h1>Manuel de Jeu - Starship Showdown</h1>
            <button id="close-overlay" class="btn-default">X</button>
            <p>Starship Showdown est un petit jeu de stratégie au tour par tour. 
                Créez votre propre flotte à partir de nombreux modèles de vaisseaux. Chaque vaisseau est capable d'utiliser des capacités basées sur les membres de leur équipage.
                Il vous est possible de lancer un combat contre une flotte ennemie, ou de personnaliser votre équipe.</p>
            <div class="section">
                <h2>Statistiques des vaisseaux</h2>
                <ul>
                    <li><strong>PV (Points de Vie)</strong> : Si un vaisseau atteint 0, il est hors combat.</li>
                    <li><strong>PT (Points de Technique)</strong> : Utilisés pour les capacités spéciales.</li>
                    <li><strong>ATK (Attaque)</strong> : Détermine les dégâts infligés.</li>
                    <li><strong>DEF (Défense)</strong> : Réduit les dégâts subis.</li>
                </ul>
            </div>
            <div class="section">
                <h2>Déroulement d'un tour</h2>
                <p>Pendant les combats, vous pourrez suivre à droite de l'écran le déroulement du combat.
                C'est ici que vous verrez en détail ce qu'il se passe à chaque tour.<br><br>
                C'est le message le plus en bas qui est le plus récent.
                </p>
                <ol>
                    <li>Un vaisseau de votre flotte est sélectionné.</li>
                    <li>Vous choisissez une capacité à utiliser contre l'ennemi de votre choix.</li>
                    <li>L'ennemi joue ensuite, puis c'est à votre tour de nouveau</li>
                </ol>
            </div>
            <div class="section">
                <h2>Capacités spéciales</h2>
                <p>Les vaisseaux peuvent utiliser des capacités qui consomment des <strong>PT</strong>. Exemples :</p>
                <ul>
                    <li><strong>Capitaine</strong> : Une attaque standard impossible à bloquer.</li>
                    <li><strong>IA</strong> : Inflige des dégâts progressifs sur plusieurs tours.</li>
                    <li><strong>Éclaireur</strong> : Réduit la défense de l'ennemi.</li>
                    <li><strong>Mécanicien</strong> : Détériore l'ennemi et lui fait perdre des PV chaque tour.</li>
                </ul>
            </div>
            <div class="section">
                <h2>Statuts</h2>
                <p>Les vaisseaux peuvent être affectés par des statuts comme <strong>Délabrement</strong>,
                 qui réduit leurs PV progressivement, et Corruption, qui rend l'ennemi confus et suceptible de se frapper lui-même 
                au lieu de son ennemi. </p>
            </div>
            <div class="section">
                <h2>Conditions de victoire</h2>
                <p>Vous gagnez si tous les vaisseaux ennemis sont détruits.</p>
                <p>Vous perdez si tous vos vaisseaux sont détruits.</p>
            </div>
        </div>
    </div>
    
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        const manualButton = document.querySelector(".btn-normal[href='#']");
        const overlay = document.getElementById("overlay");
        const closeButton = document.getElementById("close-overlay");

        if (manualButton && overlay && closeButton) {
            manualButton.addEventListener("click", function (event) {
                event.preventDefault(); // Empêche la navigation vers index.php
                overlay.style.display = "flex"; // Affiche l'overlay
            });

            closeButton.addEventListener("click", function () {
                overlay.style.display = "none"; // Cache l'overlay
            });
        }
    });

    </script>
</body>
</html>
