<?php

include_once "vaisseau.php";

class Operateur {

    public $id;
    public $name;
    public $dmg;
    public $mana_cost;
    public $effects = [];  // Tableau des effets
    public $desc;

    public function __construct($id, $name, $dmg, $mana_cost, $effects = [], $desc) {
        $this->id = $id;
        $this->name = $name;
        $this->dmg = $dmg;
        $this->mana_cost = $mana_cost;
        $this->effects = $effects; // Liste des effets associés
        $this->desc = $desc;
    }

    // Affichage des détails de l'attaque
    public function showMove() {
        return "<div class='move'><p>
                    <p class='move-name'>{$this->name}</p> 
                    <p class='move-desc'>{$this->desc}</p>
                    <p class='move-stats'>
                        <span>dégâts : {$this->dmg}</span>
                        <span>coût en PT : {$this->mana_cost}</span>
                    </p>
                </div>";
    }

    public function applyEffects($vaisseau) {
        foreach ($this->effects as $effect) {
            switch ($effect) {
                case 'Défense-':
                    $vaisseau->def = max($vaisseau->def*0.7, 1); // Réduit la défense mais la limite à 1 min
                    break;
                case 'Attaque-':
                    $vaisseau->def = max($vaisseau->atk*0.8, 1); // Réduit l'attaque mais la limite à 1 min
                    break;
                case 'Délabré':
                    $vaisseau->applyStatus('Délabré');
                    break;
                case 'Corrompu':
                    $vaisseau->applyStatus('Corrompu');
                    break;
                    
                default:
                    break;
            }
        }
    }
    
}

?>
