<?php
include_once "vaisseau.php";
include_once "operateur.php";
include_once "flotte.php";
include_once "dex.php";

session_start();

if (!isset($_SESSION['login'])) {
    // Si l'utilisateur n'est pas connecté, rediriger vers la page de connexion
    header("Location: authentification/connexion.php");
    exit();
}

$response = "";
$combatGagne = false;
$combatPerdu = false;

try {
    $host = 'localhost'; 
    $db = 'starship_showdown';  
    $user = 'root';  
    $pass = ''; 
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8";

    // Créer une instance PDO
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Récupérer le login de l'utilisateur connecté
    $login = $_SESSION['login'];

    // Requête pour récupérer la flotte de l'utilisateur
    $stmt = $pdo->prepare("SELECT * FROM flotte WHERE login = :login");
    $stmt->execute(['login' => $login]);
    $flotte = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($flotte) {
        // Récupérer les IDs des vaisseaux
        $vaisseaux = [
            $flotte['vaisseau_1'],
            $flotte['vaisseau_2'],
            $flotte['vaisseau_3'],
            $flotte['vaisseau_4'],
            $flotte['vaisseau_5']
        ];
        
        // Récupérer les détails des vaisseaux à partir de leur ID
        $vaisseauxDetails = [];
        foreach ($vaisseaux as $vaisseauId) {
            if (isset($liste_vaisseaux[$vaisseauId])) {
                $vaisseauxDetails[] = $liste_vaisseaux[$vaisseauId]; 
            }
        }
    } else {
        $vaisseauxDetails = [];  // Aucun vaisseau trouvé
    }

} catch (PDOException $e) {
    echo 'Erreur : ' . $e->getMessage();
    $vaisseauxDetails = [];
}

// Fonction pour enregistrer uniquement le nom de l'attaquant actuel
function enregistrerAttaquantActuel($attaquantJoueur) {
    $_SESSION['attaquantActuel'] = $attaquantJoueur->name;
}

function enregistrerEnnemiActuel($attaquantEnnemi) {
    $_SESSION['ennemiActuel'] = $attaquantEnnemi->name;
}

// Fonction pour réinitialiser le combat
function reinitialiserCombat() {
    // Suppression des données de combat dans la session
    unset($_SESSION['flotteJoueur']);
    unset($_SESSION['flotteEnnemi']);
    unset($_SESSION['operateurs']);
    unset($_SESSION['tourIndex']);
    
    // Réinitialisation des flottes et opérateurs pour le combat
    global $vaisseauxDetails; // Assurez-vous que $vaisseauxDetails est accessible
    initialiser_flotte($vaisseauxDetails);
}

// Vérifiez si "reset" est défini dans $_POST et appelez la fonction
if (isset($_POST['reset'])) {
    reinitialiserCombat();
}

if (isset($_POST['abandon'])) {
    reinitialiserCombat();
}


function initialiser_flotte($vaisseauxDetails) {
    // Création des opérateurs
    $capitaine = new Operateur(0,"Capitaine", 20, 0, null, "La capacité inflige des dégâts standards. Impossible à bloquer.");
    $eclaireur = new Operateur(1,"Éclaireur", 10, 6, ['Défense-'],"Baisse légèrement la défense de l'ennemi.");
    $ia = new Operateur(2,"IA", 10, 7, ['Corrompu'], "Inflige de légers dégâts, mais corromp son adversaire, qui de s'attaquer lui-même dans les tours à venir.");
    $mecanicien = new Operateur(3, "Mécanicien", 10, 5, ['Délabré'], "Le mécano déglingue le vaisseau ennemi, ce qui le délabre et lui fait perdre un peu de PV chaque tour.");
    $scientifique = new Operateur(4, "Scientifique", 0, 6, ['Attaque-'], "Réduit l'attaque de l'ennemi.");


    // Création des vaisseaux à partir des détails passés
    $vaisseau1 = $vaisseauxDetails[0];
    $vaisseau2 = $vaisseauxDetails[1];
    $vaisseau3 = $vaisseauxDetails[2];
    $vaisseau4 = $vaisseauxDetails[3];
    $vaisseau5 = $vaisseauxDetails[4];

    // Flotte facile (5 vaisseaux)
    $vaisseauEnnemi1 = new Vaisseau(100, "Nekvah", 180, 70, 30, 3);
    $vaisseauEnnemi2 = new Vaisseau(101, "Abelohn", 150, 60, 25, 4);
    $vaisseauEnnemi3 = new Vaisseau(102, "Namharnat", 120, 50, 22, 3);
    $vaisseauEnnemi4 = new Vaisseau(103, "Ezalel", 200, 80, 35, 4);
    $vaisseauEnnemi5 = new Vaisseau(104, "Holon", 170, 75, 28, 5);

    // Flotte facile (5 vaisseaux)
    $flotteEnnemi1 = new Flotte("Loubards du système solaire", [
        $vaisseauEnnemi1, $vaisseauEnnemi2, $vaisseauEnnemi3,
        $vaisseauEnnemi4, $vaisseauEnnemi5
    ]);

    // Flotte moyenne (5 vaisseaux)
    $vaisseauEnnemi6 = new Vaisseau(105, "Croiseur Noir", 250, 110, 45, 5);
    $vaisseauEnnemi7 = new Vaisseau(106, "Cuirassé Féroce", 230, 100, 50, 6);
    $vaisseauEnnemi8 = new Vaisseau(107, "Vaisseau Rapide", 280, 120, 55, 6);
    $vaisseauEnnemi9 = new Vaisseau(108, "Tank Blindé", 320, 130, 60, 7);
    $vaisseauEnnemi10 = new Vaisseau(109, "Vaisseau Fureur", 270, 125, 50, 5);

    // Flotte moyenne (5 vaisseaux)
    $flotteEnnemi2 = new Flotte("Gros méchants intergalactiques", [
        $vaisseauEnnemi6, $vaisseauEnnemi7, $vaisseauEnnemi8,
        $vaisseauEnnemi9, $vaisseauEnnemi10
    ]);

    // Flotte difficile (5 vaisseaux)
    $vaisseauEnnemi11 = new Vaisseau(110, "Démon Stellaire", 350, 140, 65, 7);
    $vaisseauEnnemi12 = new Vaisseau(111, "Apocalypse", 330, 130, 70, 7);
    $vaisseauEnnemi13 = new Vaisseau(112, "Trou Noir", 310, 120, 75, 8);
    $vaisseauEnnemi14 = new Vaisseau(113, "Titan Réacteur", 340, 135, 80, 8);
    $vaisseauEnnemi15 = new Vaisseau(114, "Ultimatum Intergalactique", 320, 140, 85, 8);

    // Flotte difficile (5 vaisseaux)
    $flotteEnnemi3 = new Flotte("Interpol de l'espace", [
        $vaisseauEnnemi11, $vaisseauEnnemi12, $vaisseauEnnemi13,
        $vaisseauEnnemi14, $vaisseauEnnemi15
    ]);



    // Création des flottes
    $flotteJoueur = new Flotte("Joueur", [$vaisseau1, $vaisseau2, $vaisseau3, $vaisseau4, $vaisseau5]);
    $flotteEnnemi = $flotteEnnemi1;

    // Stockage dans la session
    $_SESSION['flotteJoueur'] = $flotteJoueur;
    $_SESSION['flotteEnnemi'] = $flotteEnnemi;
    $_SESSION['operateurs'] = [$capitaine, $eclaireur, $ia, $mecanicien, $scientifique];
    $_SESSION['tourIndex'] = 0; // Premier tour = tour 0
}

// Initialisation des flottes si elles ne sont pas dans la session
if (!isset($_SESSION['flotteJoueur']) || !isset($_SESSION['flotteEnnemi']) || !isset($_SESSION['operateurs'])) {
    initialiser_flotte($vaisseauxDetails);
}

// Charger les flottes et opérateurs depuis la session
$flotteJoueur = $_SESSION['flotteJoueur'];
$flotteEnnemi = $_SESSION['flotteEnnemi'];

$operateurs = $_SESSION['operateurs'];
$capitaine = $operateurs[0];
$eclaireur = $operateurs[1];
$ia = $operateurs[2];
$mecanicien = $operateurs[3];
$scientifique = $operateurs[4];

$tourIndex = $_SESSION['tourIndex'];


if (isset($_POST['moveChoice'])) {

    $choix ="<div class = 'choice-list'>";
    
    // Boucle pour récupérer les vaisseaux ennemis encore en vie
    foreach ($flotteEnnemi->vaisseaux as $key => $vaisseau) {
        if ($vaisseau->pv > 0) {
            // Créer une div avec les informations du vaisseau
            $choix .= "<button id='vaisseau-choice' class='vaisseau-choice albert-sans btn-choix' data-vaisseau-id='{$key}'>
            <p>{$vaisseau->name}</p>
            </button>";
        }
    }
    $choix .= "</div>";  
    echo $choix;
    exit();
}



// Pour savoir qui est le vaisseau actif
if (count($flotteJoueur->vaisseaux) > 0) {
    $attaquantJoueur = $flotteJoueur->vaisseaux[$tourIndex % count($flotteJoueur->vaisseaux)];
} else {
    $attaquantJoueur = null;
}

if ($attaquantJoueur !== null) {
    enregistrerAttaquantActuel($attaquantJoueur);
}

// Pour savoir qui est le vaisseau adverse actif
if (count($flotteEnnemi->vaisseaux) > 0) {
    $attaquantEnnemi = $flotteEnnemi->vaisseaux[$tourIndex % count($flotteEnnemi->vaisseaux)];
} else {
    $attaquantEnnemi = null;
}

if ($attaquantEnnemi !== null) {
    enregistrerEnnemiActuel($attaquantEnnemi);
}

if (isset($_POST['action']) && $_POST['action'] == 'afficherMovesList') {
    $attaquantJoueur->movesList();
    exit;
}

// Vérifie si l'AJAX demande l'attaquant actuel
if (isset($_POST['action']) && $_POST['action'] == 'afficherAttaquantActuel') {
    // Retourne le nom de l'attaquant actuel
    $attaquantActuel = "À <strong class='atkact'>{$_SESSION['attaquantActuel']}</strong> DE JOUER !";
    echo $attaquantActuel;
    exit();
}

// Vérifie si l'AJAX demande l'attaquant actuel
if (isset($_POST['action']) && $_POST['action'] == 'afficherEnnemiActuel') {
    // Retourne le nom de l'attaquant actuel
    $ennemiActuel = " - <strong> L'ennemi {$_SESSION['ennemiActuel']}</strong> est actif";
    echo $ennemiActuel;
    exit();
}



// Affichage initial des flottes

echo $flotteEnnemi->afficherFlotte();
echo $flotteJoueur->afficherFlotte();




if (isset($_POST['attack1'])) {
    $vaisseauChoisiId = isset($_POST['vaisseau_id']) ? $_POST['vaisseau_id'] : null;
    $moveId = isset($_POST['move_id']) ? $_POST['move_id'] : null;

    if ($vaisseauChoisiId !== null) {
        // Attaque du joueur sur le vaisseau ennemi
        $cibleEnnemi = $flotteEnnemi->vaisseaux[$vaisseauChoisiId];
        $operateurChoisi = $operateurs[$moveId];
        $attaqueTexteJoueur = $attaquantJoueur->useMove($operateurChoisi, $cibleEnnemi);

        // Vérifier les PV du vaisseau ennemi
        if ($cibleEnnemi->pv <= 0) {
            unset($flotteEnnemi->vaisseaux[$vaisseauChoisiId]);
            $flotteEnnemi->vaisseaux = array_values($flotteEnnemi->vaisseaux);
            $attaqueTexteJoueur .= "<p>Le vaisseau ennemi {$cibleEnnemi->name} est hors combat !</p>";
        }

        // Riposte de l'ennemi
        if (!empty($flotteEnnemi->vaisseaux) && $cibleEnnemi->pv > 0) {

            $cibleJoueur = $attaquantJoueur;
            $attaqueTexteEnnemi = $attaquantEnnemi->useMove($capitaine, $cibleJoueur);

            if ($cibleJoueur->pv <= 0) {
                unset($flotteJoueur->vaisseaux[$tourIndex % count($flotteJoueur->vaisseaux)]);
                $flotteJoueur->vaisseaux = array_values($flotteJoueur->vaisseaux);
                $attaqueTexteEnnemi .= "<p>Le vaisseau joueur {$cibleJoueur->name} est hors combat !</p>";
            }
        }

        // Vérifiez si la bataille est terminée (tous les vaisseaux ennemis ou du joueur sont détruits)
        if (empty($flotteEnnemi->vaisseaux)) {
            $combatGagne = true;
        }

        if (empty($flotteJoueur->vaisseaux)) {
            $combatPerdu = true;
        }

        // Affichage du texte du combat
        if ($combatGagne) {
            $texteCombat = "<div class='victory'>Tous les vaisseaux ennemis sont détruits ! Victoire du joueur.</div>";
        } elseif ($combatPerdu) {
            $texteCombat = "<div class='lose'>Tous vos vaisseaux sont détruits ! Victoire de l'ennemi.</div>";
        } else {
            $texteCombat = $attaqueTexteJoueur . $attaqueTexteEnnemi;
        }

        // Mise à jour de l'état du combat
        $_SESSION['tourIndex'] = $tourIndex + 1;
        $_SESSION['flotteJoueur'] = $flotteJoueur;
        $_SESSION['flotteEnnemi'] = $flotteEnnemi;
        
        // Construction de la réponse avec la mise à jour des informations
        $response = "<div class='text'>{$texteCombat}</div>";
        $response .= "<div class='combat-info'>";
        $response .= $flotteEnnemi->afficherFlotte();
        $response .= $flotteJoueur->afficherFlotte();
        $response .= "</div>";
        
        $tourIndex = $tourIndex+2;

        $response .= "<div class='tour'>{$tourIndex}</div>";

        
        echo $response;
        exit();
    } else {
        echo 'Aucun vaisseau ennemi sélectionné ou opérateur invalide.';
    }

}




?>
