<?php
  session_start();

  //Connexion à la base de données
  $conn = new mysqli("localhost", "marwan_trc", "pokemonepee1511", "marwan_resa_manga");

  //Variables de vérification des identifiants
  $verify = true;
  $pwd_verify = true;

  if(isset($_POST['login'])){

    $email = $_POST['email'];
    $pwd = $_POST['pwd'];

    //On récupère les données qui correspondent avec l'email renseigné
    $fetch_user = $conn->prepare("SELECT id_client, pseudo, pwd from client where email= ?");
    $fetch_user-> bind_param('s', $email);
    $fetch_user-> execute();
    $fetch_user-> store_result();

    //Si aucune donnée n'a été récupérée, alors l'email renseigné est erroné et un texte s'affiche plus bas sur la page
    if($fetch_user-> num_rows == 0){
      $verify = false;

    //Si tout est en ordre, alors on récupère les données sous forme de variables
    } else{
      $verify = true;

      $fetch_user-> bind_result($id_client, $pseudo, $hash_pwd);
      $fetch_user-> fetch();
      $fetch_user-> close();
  
      //Si le password hashé de la bdd colle avec le pwd donné par l'utilisateur, alors on peut initialiser les variables de session et rediriger l'utilisateur
      if (password_verify($pwd, $hash_pwd)){
  
        $_SESSION['pseudo'] = $pseudo;
        $_SESSION['email'] = $email;
        $_SESSION['pwd'] = $pwd;
        $_SESSION['id_client'] = $id_client;
  
        header("Location: homepage_client.php"); 
        exit();  

      } else{
        //Sinon on réaffiche un message d'erreur
        $pwd_verify = false;

      }
    }
    $conn-> close();
  }
  
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="main.css">
  <title>Connexion - Plume</title>
</head>

<body>
  <header>
     <h1>Plume - Service de location de mangas</h1>
     <nav>
        <p class="nav-admin"><a href="admin.php">Espace administrateur</a></p>
     </nav>
  </header>



  <main>

    <h2 class="connect-title">Se connecter</h2>

    <div class="auth-box">
      
      <div class="auth-choice">
        <p><a href="inscription.php">S'inscrire</a></p>
        <p><a href="connexion.php">Se connecter</a></p>
      </div>

      <form action="" class="auth" method="post">
        <label for="email">Adresse mail</label>
        <input type="email" id="email" name="email" required>
        
        <label for="pwd">Mot de passe</label>
        <input type="password" id="pwd" name="pwd" required>
      
        <input type="submit" name="login" value="Se connecter">
      </form>

      <?php 
      //Messages d'erreur
        if($verify == false){
          echo "<p class='auth-error'> Votre adresse mail n'est affilié à aucun compte client </p>";
        }
        if($pwd_verify == false){
          echo "<p class='auth-error'> Votre mot de passe est incorrect, bien que l'adresse mail soit affiliée à un compte existant </p>";
        }
      ?>

    </div>

  

  </main>

</body>
</html>