<?php
  session_start();

  //Connexion à la base de données
  $conn = new mysqli("localhost", "marwan_trc", "pokemonepee1511", "marwan_resa_manga");

  $verify = true;

  //À partir du moment ou l'utilisateur clique sur s'inscrire
  if (isset($_POST['register'])){

    //Création des variables liées aux identifiants
    $pseudo = $_POST['pseudo'];
    $email = $_POST['email'];
    $pwd = password_hash($_POST['pwd'], PASSWORD_DEFAULT);

    //Récupère tous les clients qui possèdent le même email que le nouvel utilisateur
    $fetch_id = $conn->prepare('SELECT id_client from client WHERE email = ?');
    $fetch_id-> bind_param('s', $email);
    $fetch_id-> execute();
    $fetch_id-> store_result();

    //Empêche l'utilisateur de se connecter si l'email existe déjà
    if($fetch_id-> num_rows > 0){
      $verify = false;

    } else{
      $verify = true;

      //Intègre les identifiants renseignés au sein de la table 'clients' de la base de données
      $insert = $conn->prepare("INSERT into client(pseudo, email, pwd) VALUES(?, ?, ?)");
      $insert-> bind_param('sss', $pseudo, $email, $pwd);
      $insert-> execute();
      $insert-> close();

      //Assigne l'ID du nouveau client dans une variable
      $id_client = $conn->insert_id;

      //Récupère les identifiants + l'ID et les injecte dans des variables de sessions
      $_SESSION['pseudo'] = $pseudo;
      $_SESSION['email'] = $email;
      $_SESSION['pwd'] = $pwd;
      $_SESSION['id_client'] = $id_client;

      header("Location: homepage_client.php"); 
    }
    $conn-> close();

  }

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" href="main.css">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Inscription - Plume</title>
</head>

<body>
  <header>
     <h1>Plume - Service de location de mangas</h1>
     <nav>
        <p class="nav-admin"><a href="admin.php">Espace administrateur</a></p>
     </nav>
  </header>


  <main>

    <h2 class="connect-title">S'inscrire</h2>

    <div class="auth-box">

      <div class="auth-choice">
        <p><a href="inscription.php">S'inscrire</a></p>
        <p><a href="connexion.php">Se connecter</a></p>
      </div>

      <form action="" class="auth" method="post">
        <label for="pseudo">Pseudo</label>
        <input type="text" id="pseudo" name="pseudo" required>
        
        <label for="email">Adresse mail</label>
        <input type="email" id="email" name="email" required>

        <label for="pwd">Mot de passe</label>
        <input type="password" id="pwd" name="pwd" required>
      
        <input type="submit" name="register" value="S'inscrire">
      </form>

      <?php 
        if($verify == false){
          echo "<p class='auth-error'> Cette adresse email existe déjà, veuillez en saisir une autre </p>";
        }
      ?>
      
    </div>

    
    
  </main>

</body>
</html>